/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.theme.internal;

import com.aptana.theme.ThemePlugin;
import com.aptana.theme.internal.ControlThemer;
import com.aptana.ui.util.UIUtils;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Caret;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class TextViewerThemer
extends ControlThemer {
    private static final RGB BLACK = new RGB(0, 0, 0);
    private Image fCaretImage;
    private RGB fCaretColor;
    private Cursor fCursor;

    public TextViewerThemer(ITextViewer viewer) {
        super((Control)viewer.getTextWidget());
    }

    protected boolean invasiveThemesEnabled() {
        return true;
    }

    protected boolean useEditorFont() {
        return true;
    }

    protected void applyTheme() {
        super.applyTheme();
        if (this.invasiveThemesEnabled() && !this.controlIsDisposed()) {
            this.getTextWidget().setAlwaysShowScrollBars(false);
            this.applyControlColors();
            this.overrideSelectionColor();
            this.overrideCursor();
            this.overrideCaretColor();
        }
    }

    protected Font getFont() {
        return JFaceResources.getTextFont();
    }

    private StyledText getTextWidget() {
        return (StyledText)this.getControl();
    }

    private void overrideSelectionColor() {
        if (this.getTextWidget() == null) {
            return;
        }
        Color existingSelectionBG = this.getTextWidget().getSelectionBackground();
        RGB selectionRGB = this.getCurrentTheme().getSelectionAgainstBG();
        if (!existingSelectionBG.getRGB().equals((Object)selectionRGB)) {
            this.getTextWidget().setSelectionBackground(this.getColorManager().getColor(selectionRGB));
        }
        if (!"macosx".equals(Platform.getOS())) {
            this.getTextWidget().setSelectionForeground(this.getForeground());
        }
    }

    private void overrideCursor() {
        if (this.getTextWidget() == null) {
            return;
        }
        Image cursorImage = null;
        cursorImage = this.getCurrentTheme().hasDarkBG() ? UIUtils.getImage((AbstractUIPlugin)ThemePlugin.getDefault(), (String)"/icons/ibeam-white.gif") : UIUtils.getImage((AbstractUIPlugin)ThemePlugin.getDefault(), (String)"/icons/ibeam-black.gif");
        Display display = this.getTextWidget().getDisplay();
        Cursor oldCursor = this.fCursor;
        this.fCursor = new Cursor((Device)display, cursorImage.getImageData(), 7, 11);
        this.getTextWidget().setCursor(this.fCursor);
        if (oldCursor != null) {
            oldCursor.dispose();
        }
    }

    private void overrideCaretColor() {
        if (this.getTextWidget() == null) {
            return;
        }
        RGB caretColor = this.getCurrentTheme().getCaret();
        if (caretColor == null) {
            return;
        }
        Caret caret = this.getTextWidget().getCaret();
        if (caretColor.equals((Object)BLACK)) {
            caret.setImage(null);
            return;
        }
        if (this.fCaretImage != null && this.fCaretColor.equals((Object)caretColor)) {
            return;
        }
        int x = caret.getSize().x;
        int y = caret.getSize().y;
        if (x > 0 && y > 0) {
            try {
                PaletteData data;
                if (this.getThemeManager().getCurrentTheme().hasDarkBG()) {
                    data = new PaletteData(new RGB[]{caretColor});
                } else {
                    RGB inverted = new RGB(255 - caretColor.red, 255 - caretColor.green, 255 - caretColor.blue);
                    data = new PaletteData(new RGB[]{inverted});
                }
                ImageData iData = new ImageData(x, y, 1, data);
                caret.setImage(null);
                if (this.fCaretImage != null) {
                    this.fCaretImage.dispose();
                    this.fCaretImage = null;
                }
                this.fCaretImage = new Image((Device)caret.getDisplay(), iData);
                caret.setImage(this.fCaretImage);
                this.fCaretColor = caretColor;
            }
            catch (Error error) {
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void dispose() {
        if (this.fCursor != null) {
            this.fCursor.dispose();
            this.fCursor = null;
        }
        if (this.fCaretImage != null) {
            this.fCaretImage.dispose();
            this.fCaretImage = null;
        }
        this.fCaretColor = null;
        super.dispose();
    }
}

